/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.MACAddress;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.enums.RstpPortState;
import com.cisco.pt.ipc.enums.STPPortState;
import com.cisco.pt.ipc.events.IPCEvent;

public abstract class STPProcessEvent
extends IPCEvent {
    public EventType type;

    public STPProcessEvent(IPCEventLTV ltv) {
        super(ltv);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        ROOT_CHANGED,
        STP_PORT_STATE_CHANGED,
        RSTP_PORT_STATE_CHANGED;

    }

    public static class RstpPortStateChanged
    extends STPProcessEvent {
        public String ownerSwitch;
        public Integer vlan;
        public Integer portNumber;
        public RstpPortState oldStatus;
        public RstpPortState newStatus;

        public RstpPortStateChanged(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.RSTP_PORT_STATE_CHANGED;
            this.ownerSwitch = (String)ltv.getEventParameters().get(0);
            this.vlan = (Integer)ltv.getEventParameters().get(1);
            this.portNumber = (Integer)ltv.getEventParameters().get(2);
            this.oldStatus = RstpPortState.fromIntValue((Integer)ltv.getEventParameters().get(3));
            this.newStatus = RstpPortState.fromIntValue((Integer)ltv.getEventParameters().get(4));
        }

        public String toString() {
            return super.toString() + "\n\townerSwitch = " + this.ownerSwitch + "\n\tvlan = " + this.vlan + "\n\tportNumber = " + this.portNumber + "\n\toldStatus = " + (Object)((Object)this.oldStatus) + "\n\tnewStatus = " + (Object)((Object)this.newStatus);
        }
    }

    public static class StpPortStateChanged
    extends STPProcessEvent {
        public String ownerSwitch;
        public Integer vlan;
        public Integer portNumber;
        public STPPortState oldStatus;
        public STPPortState newStatus;

        public StpPortStateChanged(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.STP_PORT_STATE_CHANGED;
            this.ownerSwitch = (String)ltv.getEventParameters().get(0);
            this.vlan = (Integer)ltv.getEventParameters().get(1);
            this.portNumber = (Integer)ltv.getEventParameters().get(2);
            this.oldStatus = STPPortState.fromIntValue((Integer)ltv.getEventParameters().get(3));
            this.newStatus = STPPortState.fromIntValue((Integer)ltv.getEventParameters().get(4));
        }

        public String toString() {
            return super.toString() + "\n\townerSwitch = " + this.ownerSwitch + "\n\tvlan = " + this.vlan + "\n\tportNumber = " + this.portNumber + "\n\toldStatus = " + (Object)((Object)this.oldStatus) + "\n\tnewStatus = " + (Object)((Object)this.newStatus);
        }
    }

    public static class RootChanged
    extends STPProcessEvent {
        public String ownerSwitch;
        public Integer vlan;
        public MACAddress oldMac;
        public Integer oldPriority;
        public MACAddress newMac;
        public Integer newPriority;

        public RootChanged(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.ROOT_CHANGED;
            this.ownerSwitch = (String)ltv.getEventParameters().get(0);
            this.vlan = (Integer)ltv.getEventParameters().get(1);
            this.oldMac = (MACAddress)ltv.getEventParameters().get(2);
            this.oldPriority = (Integer)ltv.getEventParameters().get(3);
            this.newMac = (MACAddress)ltv.getEventParameters().get(4);
            this.newPriority = (Integer)ltv.getEventParameters().get(5);
        }

        public String toString() {
            return super.toString() + "\n\townerSwitch = " + this.ownerSwitch + "\n\tvlan = " + this.vlan + "\n\toldMac = " + this.oldMac + "\n\toldPriority = " + this.oldPriority + "\n\tnewMac = " + this.newMac + "\n\tnewPriority = " + this.newPriority;
        }
    }
}

